unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs,
  FormOsoba, DataModule, StdCtrls, Buttons, ExtCtrls, Grids, DBGrids;


type
  TFMain = class(TForm)
    DBGrid: TDBGrid;
    Panel1: TPanel;
    Shape: TShape;
    Label1: TLabel;
    btnINSERT: TSpeedButton;
    btnEDIT: TSpeedButton;
    btnDELETE: TSpeedButton;
    btnCLOSE: TBitBtn;
    procedure DBGridKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure DBGridDblClick(Sender: TObject);
    procedure btnDELETEClick(Sender: TObject);
    procedure btnEDITClick(Sender: TObject);
    procedure btnINSERTClick(Sender: TObject);
    procedure btnCLOSEClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormActivate(Sender: TObject);

  private
	 procedure My_insert();
	 procedure My_edit();
	 procedure My_delete();

  public

  end;

var
  FMain: TFMain;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TFMain.FormActivate(Sender: TObject);
begin
	Shape.Brush.Color := clRed;
   if DM.ADOConnection1.Connected then
	begin
		Shape.Brush.Color := clGreen;
   end;
end;

procedure TFMain.FormShow(Sender: TObject);
begin
	DBGrid.Align := alClient;
end;

procedure TFMain.btnCLOSEClick(Sender: TObject);
begin
   Close();
end;

procedure TFMain.btnINSERTClick(Sender: TObject);
begin
   My_insert();
end;

procedure TFMain.DBGridDblClick(Sender: TObject);
begin
   My_edit()
end;

procedure TFMain.DBGridKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
	if Key = VK_RETURN then
   begin
		My_edit();
   end;

	if Key = VK_INSERT then
   begin
		My_insert();
   end;

	if Key = VK_DELETE then
   begin
		My_delete();
   end;
end;

procedure TFMain.btnEDITClick(Sender: TObject);
begin
   My_edit();
end;

procedure TFMain.btnDELETEClick(Sender: TObject);
begin
   My_delete();
end;

procedure TFMain.My_insert();
var
	res : TModalResult;

begin
	res := mrNone;

   FOsoba := TFOsoba.Create(Application, false);
   try
      res := FOsoba.ShowModal();
      if res = mrOk then
      begin
         // empty
      end;
	finally
   	FreeAndNil(FOsoba);
      DBGrid.SetFocus();
   end;
end;

procedure TFMain.My_delete();
var
	res : Integer;
	id  : Integer;

begin
	id := 0;

   // ma sens jeeli istniej rekordy
   if DM.ADODataSetBrowse.RecordCount = 0 then
   begin
      ShowMessage('Brak rekordw');
   	exit;
   end;

   res := MessageBox(0, 'Usun rekord', 'Ostrzeenie', MB_YESNO);
   if res = IDYES then
   begin
      // odczytuj dane aktualnego rekordu
      id := DM.ADODataSetBrowse.FieldByName('IDOSOBY').AsInteger;

      try
         DM.adocDELETE.Parameters.ParamByName('IDOSOBY').Value := id;
         DM.adocDELETE.Execute();
		finally
         DM.ADODataSetBrowse.Close();
         DM.ADODataSetBrowse.Open();
         DBGrid.SetFocus();
      end;
   end;
end;

procedure TFMain.My_edit();
var
	res : TModalResult;

begin
   // ma sens tylko gdy s jakiekolwiek rekordy
   if DM.ADODataSetBrowse.RecordCount = 0 then
   begin
      ShowMessage('Brak rekordw');
   	exit;
   end;

   FOsoba := TFOsoba.Create(Application, true);
   try
      res := FOsoba.ShowModal();
      if res = mrOk then
      begin
         // empty
      end;
	finally
   	FreeAndNil(FOsoba);
      DBGrid.SetFocus();
   end;
end;

end.
